/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.entity.crude;

import com.dhanantry.scapeandrunparasites.block.BlockGore;
import com.dhanantry.scapeandrunparasites.entity.EntityBody;
import com.dhanantry.scapeandrunparasites.entity.EntityRemain;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityBodyParts;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityCanSpawn;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.entity.projectile.EntityGore;
import com.dhanantry.scapeandrunparasites.init.SRPBlocks;
import com.dhanantry.scapeandrunparasites.init.SRPPotions;
import com.dhanantry.scapeandrunparasites.init.SRPSounds;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import energon.srpextra.encyclopedia.ParasiteDataHandler;
import energon.srpextra.encyclopedia.data.ParasiteDataBase;
import energon.srpextra.entity.INeutralParasite;
import energon.srpextra.entity.ai.SRPEAI_Swimming;
import energon.srpextra.entity.crude.SRPEPCrude;
import energon.srpextra.events.ParasiteEvent;
import energon.srpextra.init.SRPEEffects;
import energon.srpextra.init.SRPEItems;
import energon.srpextra.util.Utilities;
import energon.srpextra.util.preset.SRPEEntitySpawnRules;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityFog
extends SRPEPCrude
implements EntityBodyParts,
INeutralParasite,
EntityCanSpawn {
    public static final DataParameter<Boolean> SCREAMING = EntityDataManager.func_187226_a(EntityFog.class, (DataSerializer)DataSerializers.field_187198_h);
    public int cooldown = 20;
    public int teleportCooldown = 50;
    public int changeSkinCooldown = 100;
    public int aggressive = 0;
    public int effectSpread = 100;
    public EntityBody HEAD;
    public float headAngle = 0.0f;
    public float preHeadAngle = 0.0f;

    public EntityFog(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.8f, 2.95f);
        this.HEAD = new EntityBody((EntityParasiteBase)this, 0.7f, 1.2f, 1.0f, 0.3f, 2.8f, -1, 1, false);
        this.canModRender = 1;
    }

    @Override
    public ParasiteDataBase getData() {
        return ParasiteDataHandler.CRUDE_WENDIGO;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("aggressive_srpe", this.aggressive);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.aggressive = compound.func_74762_e("aggressive_srpe");
    }

    public int getIDSpawn() {
        return this.getData().getTransformDataID();
    }

    public int canSpawnByIDData() {
        return this.getData().getCountNaturalTransformForPhaseSpawn();
    }

    public float func_70047_e() {
        return 2.7f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SCREAMING, (Object)false);
    }

    public boolean isScreaming() {
        return (Boolean)this.field_70180_af.func_187225_a(SCREAMING);
    }

    public void setScreaming(boolean value) {
        this.field_70180_af.func_187227_b(SCREAMING, (Object)value);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new SRPEAI_Swimming((EntityMob)this, 0.25, 0.15f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        super.func_184651_r();
    }

    protected void func_70619_bc() {
        if (this.aggressive != 0) {
            this.aggressive = Math.max(this.aggressive - 1, 0);
            if (!this.isScreaming()) {
                this.setScreaming(true);
            }
        } else if (this.isScreaming()) {
            this.setScreaming(false);
        }
        if (this.teleportCooldown != 0) {
            this.teleportCooldown = Math.max(this.teleportCooldown - 1, 0);
        }
        if (this.cooldown != 0) {
            this.cooldown = Math.max(this.cooldown - 1, 0);
        }
        if (this.changeSkinCooldown != 0) {
            this.changeSkinCooldown = Math.max(this.changeSkinCooldown - 1, 0);
        }
        if (this.effectSpread != 0) {
            this.effectSpread = Math.max(this.effectSpread - 1, 0);
        } else {
            this.effectSpread = 300;
            this.spreadEffectConfused();
        }
        if (this.aggressive > 0) {
            EntityLivingBase target = this.func_70638_az();
            if (target != null) {
                this.func_70671_ap().func_75651_a((Entity)target, 90.0f, 40.0f);
                if (this.cooldown == 0) {
                    EntityPlayer player;
                    this.cooldown = 10;
                    if (target instanceof EntityPlayer && ((player = (EntityPlayer)target).func_184812_l_() || player.func_175149_v())) {
                        this.func_70624_b(null);
                        return;
                    }
                    double distanceSq = target.func_70092_e(this.field_70165_t, this.field_70163_u + 1.2, this.field_70161_v);
                    if (distanceSq > 12.0) {
                        if (distanceSq < 500.0) {
                            if (target.field_70165_t != this.targetX || target.field_70161_v != this.targetZ) {
                                if (!this.field_70699_by.func_75497_a((Entity)target, 1.1)) {
                                    if (this.teleportCooldown == 0) {
                                        if (this.teleportToTarget(target)) {
                                            this.field_70699_by.func_75497_a((Entity)target, 1.0);
                                            this.teleportCooldown = 100;
                                        } else {
                                            this.teleportCooldown = 30;
                                        }
                                    }
                                } else {
                                    this.targetX = target.field_70165_t;
                                    this.targetZ = target.field_70161_v;
                                }
                            }
                        } else if (this.teleportCooldown == 0 && this.field_70146_Z.nextFloat() < 0.2f) {
                            if (this.teleportToTarget(target)) {
                                this.field_70699_by.func_75497_a((Entity)target, 1.0);
                                this.teleportCooldown = 100;
                            } else {
                                this.teleportCooldown = 30;
                            }
                        }
                    }
                    if (distanceSq < 16.0 && this.func_70685_l((Entity)target)) {
                        this.cooldown = 15;
                        this.changeSkill(this.field_70146_Z.nextBoolean() ? (byte)101 : 102, false);
                    }
                }
            }
        } else if (this.cooldown == 0) {
            this.cooldown = 20;
            int correctSkin = this.getSkin();
            if (correctSkin == 0) {
                if (this.changeSkinCooldown == 0) {
                    this.changeSkinCooldown = 200;
                    this.changeSkinRandom();
                }
            } else if (this.teleportCooldown == 0) {
                if ((double)this.field_70146_Z.nextFloat() < 0.2) {
                    List mobs = this.field_70170_p.func_175647_a(EntityLivingBase.class, Utilities.getBox((Entity)this, 7, 3), test -> !(test instanceof EntityPlayer));
                    if (mobs.size() < 3) {
                        EntityLivingBase newPos = Utilities.getNearestRandomEntity((EntityLivingBase)this, (int)this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e(), 8);
                        if (newPos != null) {
                            if (this.teleportToTarget(newPos)) {
                                this.teleportCooldown = 150;
                                if (newPos instanceof EntityCow) {
                                    this.setSkin(1);
                                } else if (newPos instanceof EntitySheep) {
                                    this.setSkin(2);
                                } else if (newPos instanceof EntityPig) {
                                    this.setSkin(3);
                                } else if (newPos instanceof EntityChicken) {
                                    this.setSkin(4);
                                } else if (newPos instanceof EntityWolf) {
                                    this.setSkin(5);
                                } else {
                                    this.changeSkinCooldown = 200;
                                    this.changeSkinRandom();
                                }
                                this.effectSpread = 200;
                                this.spreadEffectConfused();
                            } else {
                                this.teleportCooldown = 80;
                            }
                        } else if (this.teleportRandom()) {
                            this.teleportCooldown = 150;
                            if (this.changeSkinCooldown == 0) {
                                this.changeSkinCooldown = 200;
                                this.changeSkinRandom();
                            }
                        } else {
                            this.teleportCooldown = 80;
                        }
                        return;
                    }
                    this.teleportCooldown = 100;
                } else {
                    this.teleportCooldown = 50;
                }
            }
            boolean moveAnimal = true;
            for (EntityPlayer target : this.field_70170_p.func_175647_a(EntityPlayer.class, Utilities.getBox((Entity)this, 32, 5), test -> !test.func_175149_v() && !test.func_184812_l_())) {
                double distance = this.func_70068_e((Entity)target);
                if (distance < 10.0) {
                    this.aggressive = 300;
                    return;
                }
                if (moveAnimal && distance < 300.0 && this.field_70146_Z.nextFloat() < 0.3f) {
                    moveAnimal = false;
                    for (EntityAnimal animal : this.field_70170_p.func_72872_a(EntityAnimal.class, Utilities.getBox((Entity)this, 24, 8))) {
                        animal.func_70661_as().func_75497_a((Entity)target, 1.0);
                    }
                }
                if (correctSkin != 0 || !this.playerSeesTarget((EntityLivingBase)target, (Entity)this)) continue;
                if (this.teleportRandom()) {
                    this.teleportCooldown = 150;
                    if (this.changeSkinCooldown == 0) {
                        this.changeSkinCooldown = 200;
                        this.changeSkinRandom();
                    }
                    this.effectSpread = 200;
                    this.spreadEffectConfused();
                } else {
                    this.teleportCooldown = 80;
                }
                return;
            }
        }
    }

    @Override
    public boolean closetPlayerAttackParasite(EntityPlayer player) {
        this.aggressive = 400;
        if (this.effectSpread < 50) {
            this.effectSpread = 100;
            player.func_70690_d(new PotionEffect(SRPPotions.FEAR_E, 600, 0, false, false));
        }
        return true;
    }

    @Override
    public boolean closetPlayerAttacked(EntityPlayer player) {
        this.aggressive = 200;
        if (this.effectSpread < 100) {
            this.effectSpread = 200;
            player.func_70690_d(new PotionEffect(SRPPotions.FEAR_E, 900, 0, false, false));
        }
        return true;
    }

    @Override
    public void setTarget(EntityLivingBase target) {
        if (this.func_70638_az() == null) {
            this.aggressive += 10;
            super.func_70624_b(target);
        }
    }

    @Override
    public void setAggressive(boolean value) {
        this.aggressive = value ? 400 : 0;
    }

    @Override
    public boolean isAggressive() {
        return this.aggressive > 0;
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (this.aggressive > 0) {
            super.func_70624_b(target);
            if (target != null && this.effectSpread < 50) {
                this.effectSpread = 100;
                target.func_70690_d(new PotionEffect(SRPPotions.FEAR_E, 600, 0, false, false));
            }
        }
    }

    protected void func_70665_d(DamageSource source, float amount) {
        super.func_70665_d(source, amount);
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.cooldown = Math.min(this.cooldown, 15);
        this.changeSkinCooldown = Math.min(this.changeSkinCooldown + 50, 300);
        this.aggressive = 400;
        if (this.getSkin() != 0) {
            this.setSkin(0);
        }
        if (this.teleportCooldown == 0 && source.func_76346_g() instanceof EntityLivingBase && (double)this.field_70146_Z.nextFloat() < 0.3 && this.teleportToTarget((EntityLivingBase)source.func_76346_g())) {
            this.cooldown = 25;
            this.field_70699_by.func_75497_a(source.func_76346_g(), 1.0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 101: 
            case 102: {
                this.performAttack = true;
                this.skillProgress = 0.0f;
                this.animationProgressPRE = 0.0f;
                this.skillID = id;
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    @Override
    public void skillProgressHandler() {
        block0 : switch (this.skillID) {
            case 101: {
                this.skillProgress = Math.min(this.skillProgress + 0.1f, 1.0f);
                if (this.field_70170_p.field_72995_K || !this.performAttack || !(this.skillProgress > 0.5f)) break;
                this.performAttack = false;
                this.aggressive += 50;
                int max = 3;
                for (EntityLivingBase targetTT : Utilities.getTargetInZone((EntityLivingBase)this, 20.0f, 2.0f, -1.0f, 2.0f, 5.0f)) {
                    if (--max < 0) break block0;
                    this.func_70652_k((Entity)targetTT);
                    if (!((double)this.field_70146_Z.nextFloat() < 0.15)) continue;
                    targetTT.func_70690_d(new PotionEffect(SRPPotions.BLEED_E, 1, 100));
                }
                break;
            }
            case 102: {
                this.skillProgress = Math.min(this.skillProgress + 0.1f, 1.0f);
                if (this.field_70170_p.field_72995_K || !this.performAttack || !(this.skillProgress > 0.5f)) break;
                this.performAttack = false;
                this.aggressive += 50;
                int max = 3;
                for (EntityLivingBase targetTT : Utilities.getTargetInZone((EntityLivingBase)this, -20.0f, 2.0f, -1.0f, 2.0f, 5.0f)) {
                    if (--max < 0) break block0;
                    this.func_70652_k((Entity)targetTT);
                    if (!((double)this.field_70146_Z.nextFloat() < 0.15)) continue;
                    targetTT.func_70690_d(new PotionEffect(SRPPotions.BLEED_E, 1, 100));
                }
                break;
            }
            default: {
                this.skillProgress = Math.min(this.skillProgress + 0.05f, 1.0f);
            }
        }
    }

    public void spreadEffectConfused() {
        for (EntityLivingBase target : this.field_70170_p.func_72872_a(EntityLivingBase.class, Utilities.getBox((Entity)this, 32, 12))) {
            if (!this.field_70146_Z.nextBoolean()) continue;
            target.func_70690_d(new PotionEffect(SRPEEffects.CONFUSED, 900, 0, false, false));
        }
    }

    public boolean teleportRandom() {
        this.field_70699_by.func_75499_g();
        for (int i = 0; i < 3; ++i) {
            BlockPos pos = Utilities.getRandomTeleportationPosition(this.func_180425_c(), this.field_70170_p, SRPEEntitySpawnRules.RULE_THREE, 24, 8, 8, 12, this.field_70146_Z);
            if (pos == null) continue;
            this.func_70634_a((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f);
            return true;
        }
        return false;
    }

    public boolean teleportToTarget(EntityLivingBase target) {
        this.field_70699_by.func_75499_g();
        int radi = target instanceof EntityPlayer ? 10 : 6;
        int deRadi = target instanceof EntityPlayer ? 6 : 2;
        for (int i = 0; i < 3; ++i) {
            BlockPos pos = Utilities.getRandomTeleportationPosition(target.func_180425_c(), this.field_70170_p, SRPEEntitySpawnRules.RULE_THREE, radi, 3, 5, deRadi, this.field_70146_Z);
            if (pos != null) {
                this.func_70634_a((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f);
                return true;
            }
            if (!(this.field_70146_Z.nextFloat() < 0.2f)) continue;
            return false;
        }
        return false;
    }

    public void changeSkinRandom() {
        this.setSkin(1 + this.field_70146_Z.nextInt(5));
    }

    public boolean playerSeesTarget(EntityLivingBase player, Entity target) {
        Vec3d vec3d = player.func_70676_i(1.0f).func_72432_b();
        Vec3d vec3d1 = new Vec3d(target.field_70165_t - player.field_70165_t, target.func_174813_aQ().field_72338_b + (double)target.func_70047_e() - (player.field_70163_u + (double)player.func_70047_e()), target.field_70161_v - player.field_70161_v);
        double d0 = vec3d1.func_72433_c();
        double d1 = vec3d.func_72430_b(vec3d1 = vec3d1.func_72432_b());
        return d1 > 1.0 - 0.4 / d0 && player.func_70685_l(target);
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadAngle(float partialTick) {
        return this.headAngle == 0.0f ? 0.0f : this.preHeadAngle + (this.headAngle - this.preHeadAngle) * partialTick;
    }

    @Override
    public void func_70636_d() {
        IBlockState state;
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K && this.preHeadAngle != this.headAngle) {
            this.preHeadAngle = this.headAngle;
        }
        this.headAngle = (state = this.field_70170_p.func_180495_p(this.func_180425_c().func_177981_b(3))).func_177230_c() != Blocks.field_150350_a && !state.func_185904_a().func_76224_d() ? Math.min(this.headAngle + 0.07f, 1.0f) : Math.max(this.headAngle - 0.08f, 0.0f);
        if (this.HEAD != null && this.partUpdate(this.HEAD, 0.0f, 0.7f + this.headAngle * 0.7f, 2.9f - this.headAngle * 0.7f)) {
            this.field_70170_p.func_72973_f((Entity)this.HEAD);
            this.HEAD = null;
        }
    }

    public boolean partUpdate(EntityBody part, float angle, float offset, float offsetHeight) {
        if (part.getFather() == null || this.field_70128_L) {
            return true;
        }
        part.func_70071_h_();
        double yawRad = Math.toRadians(this.field_70177_z + angle);
        double offsetX = -MathHelper.func_76126_a((float)((float)yawRad)) * offset;
        double offsetZ = MathHelper.func_76134_b((float)((float)yawRad)) * offset;
        double X = this.field_70165_t + offsetX;
        double Y = this.field_70163_u + (double)offsetHeight;
        double Z = this.field_70161_v + offsetZ;
        part.func_70107_b(X, Y, Z);
        return false;
    }

    public boolean attackEntityBodyFrom(DamageSource damageSource, float v, int i, boolean b) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        return this.func_70097_a(damageSource, v * 1.5f);
    }

    public void setBodyPartDead(int i) {
        if (i == 1 && this.HEAD != null) {
            this.field_70170_p.func_72973_f((Entity)this.HEAD);
            this.HEAD = null;
        }
    }

    public void onRemovedFromWorld() {
        if (this.HEAD != null) {
            this.field_70170_p.func_72973_f((Entity)this.HEAD);
            this.HEAD = null;
        }
        super.onRemovedFromWorld();
    }

    @Override
    protected void spawnGore() {
        if (SRPConfig.paraGore && !MinecraftForge.EVENT_BUS.post((Event)new ParasiteEvent.PlaceBlockGore((EntityParasiteBase)this))) {
            int range = 2;
            double currentHeight = MathHelper.func_76128_c((double)(this.field_70163_u + 0.1));
            double currentPosX = this.field_70165_t;
            double currentPosZ = this.field_70161_v;
            for (int offsetX = -range; offsetX <= range; ++offsetX) {
                for (int offsetZ = -range; offsetZ <= range; ++offsetZ) {
                    double blockPosX = currentPosX + (double)offsetX;
                    double blockPosZ = currentPosZ + (double)offsetZ;
                    BlockPos blockPos = new BlockPos(blockPosX, currentHeight, blockPosZ);
                    Block blockAtPos = this.field_70170_p.func_180495_p(blockPos).func_177230_c();
                    Block blockBelow = this.field_70170_p.func_180495_p(blockPos.func_177977_b()).func_177230_c();
                    if (blockAtPos != Blocks.field_150350_a || blockBelow == Blocks.field_150350_a || !this.field_70170_p.func_180495_p(blockPos.func_177977_b()).func_185913_b() || blockBelow == SRPBlocks.InfestedStain || this.field_70170_p.field_73012_v.nextInt(6) != 0) continue;
                    this.field_70170_p.func_175656_a(blockPos, SRPBlocks.Gore.func_176223_P().func_177226_a((IProperty)BlockGore.VARIANT, (Comparable)BlockGore.EnumType.PRI_FLAT));
                }
            }
        }
        if (!MinecraftForge.EVENT_BUS.post((Event)new ParasiteEvent.PlaceRemain((EntityParasiteBase)this)) && this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).func_185913_b() && (this.field_70170_p.func_180495_p(this.func_180425_c()).func_177230_c() instanceof BlockBush || this.field_70170_p.func_180495_p(this.func_180425_c()).func_177230_c() == Blocks.field_150350_a)) {
            this.field_70170_p.func_175656_a(this.func_180425_c(), SRPBlocks.Gore.func_176223_P().func_177226_a((IProperty)BlockGore.VARIANT, (Comparable)BlockGore.EnumType.PRI_BIG));
            EntityRemain remain = new EntityRemain(this.field_70170_p);
            remain.func_70107_b((double)this.func_180425_c().func_177958_n() + 0.5, (double)this.func_180425_c().func_177956_o(), (double)this.func_180425_c().func_177952_p() + 0.5);
            ResourceLocation key = EntityList.func_191301_a((Entity)this);
            remain.setParasite(key != null ? key.toString() : "srparasites:buglin");
            remain.setSkin((byte)this.getSkin());
            remain.setGoal(20 * SRPConfig.primitiveRemainValue);
            this.field_70170_p.func_72838_d((Entity)remain);
        }
        if (SRPConfig.paraGore && !MinecraftForge.EVENT_BUS.post((Event)new ParasiteEvent.SpawnEntityGore((EntityParasiteBase)this))) {
            for (int i = 0; i < 3; ++i) {
                EntityGore goreEntity = new EntityGore(this.field_70170_p);
                goreEntity.setType((byte)2);
                goreEntity.func_82149_j((Entity)this);
                goreEntity.setMotion((double)(this.field_70146_Z.nextFloat() * 0.15f), (double)(this.field_70146_Z.nextFloat() * 0.6f + 0.1f), (double)(this.field_70146_Z.nextFloat() * 0.15f), 0.1, 0.5);
                this.field_70170_p.func_72838_d((Entity)goreEntity);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.spawnMobsInside();
        }
    }

    public ItemStack getPickedResult(RayTraceResult p_getPickedResult_1_) {
        return new ItemStack(SRPEItems.itemmobspawner_fog);
    }

    protected SoundEvent func_184615_bR() {
        switch (this.getSkin()) {
            case 1: {
                return SoundEvents.field_187560_al;
            }
            case 2: {
                return SoundEvents.field_187759_eH;
            }
            case 3: {
                return SoundEvents.field_187700_dM;
            }
            case 4: {
                return SoundEvents.field_187663_X;
            }
        }
        return SRPSounds.MOBSILENCE;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_getHurtSound_1_) {
        switch (this.getSkin()) {
            case 1: {
                return SoundEvents.field_187562_am;
            }
            case 2: {
                return SoundEvents.field_187761_eI;
            }
            case 3: {
                return SoundEvents.field_187703_dN;
            }
            case 4: {
                return SoundEvents.field_187666_Z;
            }
        }
        return SRPSounds.MOBSILENCE;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        switch (this.getSkin()) {
            case 1: {
                return SoundEvents.field_187558_ak;
            }
            case 2: {
                return SoundEvents.field_187757_eG;
            }
            case 3: {
                return SoundEvents.field_187697_dL;
            }
            case 4: {
                return SoundEvents.field_187660_W;
            }
        }
        return SRPSounds.MOBSILENCE;
    }

    protected void func_180429_a(BlockPos p_playStepSound_1_, Block p_playStepSound_2_) {
        this.func_184185_a(this.getStepSound(), 0.05f, 1.0f);
    }

    protected SoundEvent getStepSound() {
        switch (this.getSkin()) {
            case 1: {
                return SoundEvents.field_187566_ao;
            }
            case 2: {
                return SoundEvents.field_187765_eK;
            }
            case 3: {
                return SoundEvents.field_187709_dP;
            }
            case 4: {
                return SoundEvents.field_187538_aa;
            }
        }
        return SRPSounds.MONSTER_STEP;
    }
}

